/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.dialog.VWFieldUsageDialog;
import filenet.vw.toolkit.design.property.dialog.VWStepItem;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import javax.swing.event.ListSelectionEvent;

class VWSelectStepPanel
extends VWAddRemovePanel {
    private VWFieldUsageDialog m_parentDialog = null;

    public VWSelectStepPanel(VWFieldUsageDialog parentDialog, int nFlags) {
        super(nFlags);
        this.m_parentDialog = parentDialog;
        this.setAvailableItemName(VWResource.s_availableSteps);
        this.setSelectedItemName(VWResource.s_selectedSteps);
    }

    public void emptyLists() {
        try {
            this.m_availableList.removeAll();
            this.m_selectedList.removeAll();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void refreshUI() {
        try {
            this.setVisible(false);
            this.setVisible(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addItem(VWStepItem newStep) {
        try {
            VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
            listModel.addElement(newStep);
            listModel.sort();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void sortLists() {
        try {
            VWSortedListModel availableListModel = (VWSortedListModel)this.m_availableList.getModel();
            VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
            if (availableListModel != null) {
                availableListModel.sort();
            }
            if (selectedListModel != null) {
                selectedListModel.sort();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void renameItem(String oldName, String newName, VWMapNode mapNode) {
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            Object object = event.getSource();
            super.valueChanged(event);
            if (object == this.m_selectedList) {
                int[] indices = this.m_selectedList.getSelectedIndices();
                if (indices.length == 1) {
                    VWStepItem step = (VWStepItem)this.m_selectedList.getSelectedValue();
                    this.m_parentDialog.updateSelectedStepProperties(step);
                } else {
                    this.m_parentDialog.updateSelectedStepProperties(null);
                }
            } else {
                this.m_parentDialog.updateAvailableStepProperties(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Object[] getSelectedStepItems() {
        Object[] items = null;
        try {
            items = this.m_selectedList.getSelectedValues();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    protected int isInArray(VWSortedListModel listModel, Object item, Object[] items) {
        if (items == null || items.length < 1) {
            return -1;
        }
        int stepId = ((VWStepItem)item).getDef().getStepId();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || ((VWStepItem)items[i]).getDef().getStepId() != stepId) continue;
            return i;
        }
        return -1;
    }

    protected void onAddItemsAction(Object[] items) {
        try {
            this.m_parentDialog.addParamToStep(items);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            this.m_parentDialog.removeParamFromStep(items);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }
}

